//
// Created by dave on 2012-05-22.
//

#import <Foundation/Foundation.h>

@class OPLoginField;


@interface OPLoginFieldList : NSArray

@property (nonatomic, readonly) NSArray *passwordFields;

@property (nonatomic, readonly) OPLoginField *usernameField;
@property (nonatomic, readonly) OPLoginField *passwordField;


- (void)addLoginField:(OPLoginField *)field;
- (OPLoginField *)loginFieldAtIndex:(NSInteger)index;

- (NSArray *)loginFieldsNotContainedWithin:(OPLoginFieldList *)fieldSet;
- (NSArray *)loginFieldsConflictingWith:(OPLoginFieldList *)fieldSet;


// [rfillion 2014-11-25] Note that it's possible for a field list to contain fields with duplicate names and values. So adding a field with a specific name/value doesn't guarantee that you'll then get that same field back using the find* methods.
- (OPLoginField *)findLoginFieldWithValue:(NSString *)value;
- (OPLoginField *)findLoginFieldWithName:(NSString *)name;
- (OPLoginField *)findOldPasswordLoginField;
- (OPLoginField *)findNewPasswordLoginFieldExcludingPasswordValue:(NSString *)valueToExclude;


- (void)removeLoginFieldAtIndex:(NSInteger)index;

- (OPLoginField *)loginFieldDesignatedAs:(NSString *)designation;
- (void)designateLoginFieldAt:(NSInteger)index as:(NSString *)designation;
- (OPLoginField *)addDesignatedPassword:(NSString *)string;
- (OPLoginField *)addDesignatedUsername:(NSString *)value;

- (NSArray *)allValuesForSearch;
- (NSArray *)allPasswordsForSearch;
- (NSArray *)allFieldTitlesForSearch;

@end